

/******************************************************************************************************
 **                                                                                                  **
 **                     EX5.1 : Temp Am2302 (for ET-DISPLAY 8x32RED)                                 **
 **                     Use : Dot-Matrix(8x8=4 digit) #LDM1088A ,Drive #Max7219                      **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         :   AVR Easy Mega 328 (ET-CPU DISPLAY8x32)                                   **
 **                     :   X-TAL : 16 MHz                                                           ** 
 **                                                                                                  **
 **  Editor/Compiler    :   Arduino 1.8.1                                                            **
 **                                                                                                  **                   
 **  Port Interface    :   Arduino Mega328 PIN                        Device Interface               **
 **                         ----------------------                     --------------                **                      
 **  Dot-Matrix         :   Pin D10-OUT (PB2)                           CS/Load-Max7219              **
 **                         Pin D11-OUT (PB3)                           DIN-Max7219                  **
 **                         Pin D12-OUT (PB4)                           CLK-Max7219K                 **
 **                                                                                                  **                                                                                                 
 **   Temp Sensor       :   PIN D5-OUT(PD5)                             Data-SHT15,SDA-AM2302        **
 **                         PIN D13-OUT(PB5)                            SCK-SHT15                    **   
 **                                                                                                  ** 
 **                                                                                                  **                         
 **  Create By          :   Mr.Sittiphol Yooyod (WWW.ETT.CO.TH)                                      **
 **  Last Update        :   7/December/2018                                                          ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

// MAX7219 commands:
#define CMD_NOOP   0
#define CMD_DIGIT0 1
#define CMD_DIGIT1 2
#define CMD_DIGIT2 3
#define CMD_DIGIT3 4
#define CMD_DIGIT4 5
#define CMD_DIGIT5 6
#define CMD_DIGIT6 7
#define CMD_DIGIT7 8
#define CMD_DECODEMODE  9
#define CMD_INTENSITY   10
#define CMD_SCANLIMIT   11
#define CMD_SHUTDOWN    12
#define CMD_DISPLAYTEST 15

#define NUM_MAX      4    //Number Max7219 4 Ship

/************ Define Pin **************/

//-----Dot Matrix Pin for Max7219------

#define CS_PIN       10
#define DIN_PIN      11
#define CLK_PIN      12


//----Temp Sensor DHT Am2302----
#define DHTPIN     5        // for data-Am2302
#define SCKPIN     13       // for SCK-SHT15  

#define DHTTYPE    DHT22    // DHT 22  (AM2302), AM2321


//-----------------------Buffer Display Screen ------------------------

                               //Colum      0       1      2        3
static byte ScrBuf[8][4] = {   //Position  DSP0   -DSP1    -DSP2   -DSP3       
                    {0,0,0,0},    //data   D8-D0   D8-D0   D8-D0   D8-D0  ---Row0(A0) 
                    {0,0,0,0},    //data   D8-D0   D8-D0   D8-D0   D8-D0
                    {0,0,0,0},             
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0}    //data   D8-D0   D8-D0   D8-D0   D8-D0   ---Row7(A7)
                  };           //Ex Font   'A'




/****************************************************************
 *                              Data Font                       *
 **************************************************************** 
 * //-First Byte of font[0] is NumByte / Charecter
 * -First Byte of font[0] is Type Font 1= Cuttom font,2=Full font
 * -First byte of Charecter is bit wide of Charecter     
 * -Font Read Hor Colum [ D7...D0] 
 * -Plot First Byte  from Up to Down   
 * -Font Close Left  
 *  https://www.riyas.org/2013/12/online-led-matrix-font-generator-with.html  
 * -----------------------------------------  
 *      8  4  2  1  8  4  2  1 ----->Weight
 *     D7 D6 D5 D4 D3 D2 D1 D0 ----->Data 1Byte
 *   -----------------------------
 * 0|   0  #  #  #  0  0  0  0   = 0x70    ----->    ,Ex Font0 size 5x7           
 * 1|   #  0  0  0  #  0  0  0   = 0x88
 * 2|   #  0  0  0  #  0  0  0   = 0x88
 * 3|   #  0  0  0  #  0  0  0   = 0x88
 * 4|   #  0  0  0  #  0  0  0   = 0x88
 * 5|   #  0  0  0  #  0  0  0   = 0x88
 * 6|   0  #  #  #  0  0  0  0   = 0x70  
 * 7|   0  0  0  0  0  0  0  0   = 0x00
 *  
 *  '0' = {5,0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00} 
*/  

//---------------------Font Number----------------------------------
const unsigned char Bfont6x8[] PROGMEM = {         //Font Bold Plot 
0x78,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0x78,// 0
0x30,0xF0,0x30,0x30,0x30,0x30,0x30,0xFC,// 1
0x78,0xcc,0x0c,0x18,0x30,0x60,0xc0,0xfc,// 2
0x78,0xcc,0x0c,0x38,0x0c,0x0c,0xcc,0x78,// 3
0x18,0x38,0x78,0xd8,0xd8,0xfc,0x18,0x18,// 4
0xfc,0xc0,0xc0,0xf8,0x0c,0x0c,0xcc,0x78,// 5
0x78,0xcc,0xc0,0xf8,0xcc,0xcc,0xcc,0x78,// 6
0xfc,0x0c,0x0c,0x18,0x30,0x30,0x30,0x30,// 7
0x78,0xcc,0xcc,0x78,0xcc,0xcc,0xcc,0x78,// 8
0x78,0xcc,0xcc,0xcc,0x7c,0x0c,0xcc,0x78 // 9
};

//---------------------Font Symbol----------------------------------
const unsigned char Symbol[] PROGMEM ={
0x70,0x50,0x77,0x0c,0x0c,0x0c,0x0c,0x07,  //degree 
  
};

//----------------------Font Clear buffer --------------

const unsigned char FClr[] PROGMEM = {         //Font Clear buffer
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};


//------------ Variable Temp ------------------

char tmH,tmL,ptH,ptL  ;
unsigned long Last_TimeTmp =0 ;   //= millis(); //Start Delay Time Temp;
float temp ;
  
#include <DHT.h>

DHT dht(DHTPIN, DHTTYPE);  //Temp Sensor AM2302


/*************************************************************************
 **    Function : Sent Command+Data 2Byte(16Bit) to Max7219 4-Ship      **
 *************************************************************************/            
  
void SendCmdAll(byte cmd, byte data)
{
  int dp ;
  
  digitalWrite(CS_PIN, LOW);
  
  for(dp=0 ; dp< NUM_MAX ; dp++)                 //Loop 4 round for Max7219 4 Ship
   {
     shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, cmd) ; //Shift command 8 bit byte High(D15-D8)
     shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, data); //Shift Data 8 bit byte Low(D7-D0) 
   }

  digitalWrite(CS_PIN, LOW);
  digitalWrite(CS_PIN, HIGH);
}


/****************************************************************
 **       Function : Refress Screen All (4 Display=8x32 Dot)   **
 ****************************************************************/       

void RefreshAll() 
{
  char rw,dp  ;
  
  //------------- Refresh Screen All --------------------------
  
  for (rw = 0; rw < 8 ; rw++)  //Loop Scan 8 Row  Start A0-A7 
   {
    digitalWrite(CS_PIN, LOW);
    
    for(dp = 3 ; dp >= 0 ; dp--) //Loop NUM_MAX=4 (0-3)
     {
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, CMD_DIGIT0 + rw)   ; //Shift cmm 8bit byte High (Row Address Start Row 0(Ver.))
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, ScrBuf[rw][dp])    ; //Shift data 8bit byte Low (Sent Serial data Start Buffer[row0][Colum3]
     }
    digitalWrite(CS_PIN, LOW);
    digitalWrite(CS_PIN, HIGH);                                 //Latch Data to Display
   }  
}


/**************************************************************************************************************
 **                           Function : Plot data to Screen Buffer                                          **      
 **************************************************************************************************************           
 **  Paramiter :                                                                                             **
 **              dsp = Position dsp buffer 0-3 for keep data                                                 **                                                      
 **       *name_font = Name Table font                                                                       **      
 **                                                                                                          **
 **************************************************************************************************************/
 
void PlotDot(char dsp, const unsigned char *name_font)
{
  byte dt ;
  char col,row ;
    
    for(col=0;col<4;col++)                     //Loop Position dsp buffer colum 0-3
     {
       for(row=0;row<8;row++)                  //Loop Number Byte Data of 1 Charecter row 0-7
       {
         dt = pgm_read_byte(name_font+row) ;   //Read Data 1 Byte of font from 8 Byte

         if(dsp == col)
           ScrBuf[row][col] = dt           ;   //update Data 1 byte of Charecter to buffer colume Dsp 4 colum 
        
       } //for row
  
    }  // for col 0-3

} //End Show Number


/********************************************************
 **            Function:Initial Max7219                **
 ********************************************************/          
void InitMAX7219()
{
  pinMode(DIN_PIN, OUTPUT)         ;   //D11
  pinMode(CLK_PIN, OUTPUT)         ;   //D13
  pinMode(CS_PIN, OUTPUT)          ;   //D10
  digitalWrite(CS_PIN, HIGH)       ;
  digitalWrite(CLK_PIN, LOW)       ;  //****************
    
  SendCmdAll(CMD_DISPLAYTEST, 0)   ;  //Set Display Normal Mode
  SendCmdAll(CMD_SCANLIMIT, 7)     ;  //Set Scan 8 digit is 100 HZ 
  SendCmdAll(CMD_DECODEMODE, 0)    ;
  SendCmdAll(CMD_INTENSITY, 15)    ; //Bright Max=15 ,Min=0
  SendCmdAll(CMD_SHUTDOWN, 0)      ;

  RefreshAll()                     ; 
  SendCmdAll(CMD_SHUTDOWN,1)       ;

}



 /******************************************************
  **          Function Read DHT22(AM2302)             **
  ******************************************************          
  **  Return : 0 = DHT22 Error ,1 = DHT22 Normal      **
  ******************************************************/
  
char Rd_DHT22()
 {
   float hu,tem ;
     
     // Reading temperature or humidity takes about 250 milliseconds!
     // Sensor readings may also be up to 2 seconds 'old' (its a very slow sensor)
    //  hu = dht.readHumidity();
    // Read temperature as Celsius (the default)
      tem = dht.readTemperature();
 
    // Check if any reads failed and exit early (to try again).
     if(isnan(hu) || isnan(tem)) //if hu or tem = non(1) is DTH22 fail
      {
        return 0 ;  // DHT22 Not Connected or data error
      }

      //hum  = hu  ;
      temp = tem ;
     
      return 1   ;  // DHT22 Connected and data not error
 }

 
 /******************************************************
  **           Function Read Temp AM2302              **
  ******************************************************/          
 

void Read_Temp()
{
  long tmp ;

  if(millis()-Last_TimeTmp >2000) //if time more 2 sec Read Temp
   {
       if(Rd_DHT22()) //if RD_DHT22 is 1 Device DHT22 ok
        {
         //-----------Temp Convert data for Display-------------
   
          tmp = temp*100  ;// Float to number
   
          tmH = tmp/100   ;   
          tmL = tmH%10    ;  //Unit
          tmH = tmH/10    ;  //number 10    
 

          ptH = tmp%100   ; //Fraction
          ptL = ptH%10    ; //Unit
          ptH = ptH/10    ; //number 10  
           
        }
        
      Last_TimeTmp = millis();  //delay Loop
      
   }//if mill 
}

 /********************************************************
  **                 Function Plot '.'                 **
  *******************************************************/          

void markDot ()
{ 
  char m,n  ;

  for(m=0;m<8;m++)
  {
    ScrBuf[m][1] = ScrBuf[m][1]>>2            ;   //Sfiht data in ScrBuf[] DSP1 2 bit
    ScrBuf[m][3] = ScrBuf[m][3]>>1            ;   //Sfiht data in ScrBuf[] DSP3 1 bit
  }
 
   ScrBuf[6][1] |= 0x80                        ;   //Mark '.' DSP1 bit7 of data byte6 
   ScrBuf[7][1] |= 0x80                        ;   //Mark '.' DSP1 bit7 of data byte7 
   
   ScrBuf[6][2] |= 0x01                        ;   //Mark '.' DSP2 bit0 of data byte6 
   ScrBuf[7][2] |= 0x01                        ;   //Mark '.' DSP2 bit0 of data byte7 
   
}


// ########################## Setup ####################################

void setup() 
{ 
  InitMAX7219();
  //----------DHT AM2302 Temp ----------
  dht.begin()  ; 

}


// ########################## Main Program #############################

void loop()
{  
  while(1)
   {  
     Read_Temp() ;
     
     PlotDot(3,Bfont6x8+(8*tmH))  ; //Position Start Bfont array of temp number 10
     PlotDot(2,Bfont6x8+(8*tmL))  ; //Position Start Bfont array of temp number unit
     PlotDot(1,Bfont6x8+(8*ptH))  ; //Position Start Bfont array of temp fraction 
     PlotDot(0,Symbol)            ; //Position Start Bfont array of Symbol degree
     markDot ()                   ; //Adjust position data in Scrbuf 
     
     RefreshAll()                 ;
     delay(100)                   ;    
   
   }
}  // end void







